/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.difficulty;

import com.flemmli97.improvedmobs.capability.PlayerDifficultyData;
import com.flemmli97.improvedmobs.capability.TileCapProvider;
import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.network.PacketHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IEntityReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.silentchaos512.scalinghealth.utils.config.SHDifficulty;

public class DifficultyData
extends WorldSavedData {
    private static final String identifier = "Difficulty";
    private float difficultyLevel;
    private long prevTime;

    public DifficultyData() {
        this(identifier);
    }

    private DifficultyData(String id) {
        super(id);
    }

    public static DifficultyData get(World world) {
        return (DifficultyData)world.func_73046_m().func_241755_D_().func_217481_x().func_215752_a(DifficultyData::new, identifier);
    }

    public static float getDifficulty(World world, LivingEntity e) {
        if (Config.CommonConfig.useScalingHealthMod) {
            if (Config.CommonConfig.legacyScalingHealth) {
                return (float)net.silentchaos512.scalinghealth.utils.SHDifficulty.areaDifficulty((World)world, (BlockPos)e.func_233580_cy_());
            }
            return (float)SHDifficulty.areaDifficulty((World)world, (BlockPos)e.func_233580_cy_());
        }
        Vector3d pos = e.func_213303_ch();
        switch (Config.CommonConfig.difficultyType) {
            case GLOBAL: {
                return DifficultyData.get(world).getDifficulty();
            }
            case PLAYERMAX: {
                float diff = 0.0f;
                for (PlayerEntity player : DifficultyData.playersIn((IEntityReader)world, pos, 256.0)) {
                    float pD = TileCapProvider.getPlayerDifficultyData((ServerPlayerEntity)player).map(PlayerDifficultyData::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue();
                    if (!(pD > diff)) continue;
                    diff = pD;
                }
                return diff;
            }
            case PLAYERMEAN: {
                float diff = 0.0f;
                List<PlayerEntity> list = DifficultyData.playersIn((IEntityReader)world, pos, 256.0);
                if (list.isEmpty()) {
                    return 0.0f;
                }
                for (PlayerEntity player : list) {
                    diff += TileCapProvider.getPlayerDifficultyData((ServerPlayerEntity)player).map(PlayerDifficultyData::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue();
                }
                return diff / (float)list.size();
            }
        }
        return 0.0f;
    }

    private static List<PlayerEntity> playersIn(IEntityReader getter, Vector3d pos, double radius) {
        ArrayList list = Lists.newArrayList();
        for (PlayerEntity player : getter.func_217369_A()) {
            if (!player.func_213303_ch().func_237488_a_((IPosition)pos, radius)) continue;
            list.add(player);
        }
        return list;
    }

    public void increaseDifficultyBy(Function<Float, Float> increase, long time, MinecraftServer server) {
        this.difficultyLevel += increase.apply(Float.valueOf(this.getDifficulty())).floatValue();
        this.prevTime = time;
        server.func_184103_al().func_181057_v().forEach(player -> TileCapProvider.getPlayerDifficultyData(player).ifPresent(pd -> pd.setDifficultyLevel(pd.getDifficultyLevel() + ((Float)increase.apply(Float.valueOf(pd.getDifficultyLevel()))).floatValue())));
        this.func_76185_a();
        PacketHandler.sendDifficultyToAll(this, server);
    }

    public void setDifficulty(float level, MinecraftServer server) {
        this.difficultyLevel = level;
        PacketHandler.sendDifficultyToAll(this, server);
        this.func_76185_a();
    }

    public void addDifficulty(float level, MinecraftServer server) {
        this.difficultyLevel += level;
        PacketHandler.sendDifficultyToAll(this, server);
        this.func_76185_a();
    }

    public float getDifficulty() {
        return this.difficultyLevel;
    }

    public long getPrevTime() {
        return this.prevTime;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.difficultyLevel = nbt.func_74760_g(identifier);
        this.prevTime = nbt.func_74763_f("Time");
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74776_a(identifier, this.difficultyLevel);
        compound.func_74772_a("Time", this.prevTime);
        return compound;
    }
}

